function test_suite = testSum %#ok<STOUT>
initTestSuite;

function testEmpty
x = polysym.empty;
assertTrue(isempty(sum(x)))

function testZeros %#ok<*DEFNU>
x = [polysym(0) polysym(0)];
z = sum(x);
assertEqual(z.Value,'0');

function testOneZeroOneChar
x = [polysym(0) polysym('y')];
z = sum(x);
assertEqual(z.Value,'y');

function testZeroSumReal
x = polysym(0);
y = polysym(pi);
z = sum([x y]);
assertEqual(z,y);

function testRealSumChar
x = [polysym('x') polysym(5)];
z = sum(x);
assertEqual(z.Value,'x+5');

function testScalarSumVector
x = polysym(1:3);
z = sum(x);
assertEqual(z.Value,'1+2+3');

function testVectorSumVector
x = polysym({'x','y';'u','w'});
z = sum(x);
assertEqual(z(1).Value,'x+u');
assertEqual(z(2).Value,'y+w');

function testVectorSumVectorSecondDim
x = polysym({'x','y';'u','w'});
z = sum(x,2);
assertEqual(z(1).Value,'x+y');
assertEqual(z(2).Value,'u+w');

function testVectorSumVectorThirdDim
x = polysym({'x','y';'u','w'});
f = @() sum(x,3);
assertExceptionThrown(f,'MATLAB:polysym:diff:notLess')

function testAssociative1
x = polysym('x');
y = polysym('4+y');
z = sum([x y]);
assertEqual(z.Value,'x+4+y');

function testAssociative2
x = polysym('x');
y = polysym('4*y');
z = sum([x y]);
assertEqual(z.Value,'x+4*y');
